

<?php $__env->startSection('content'); ?>
    <div class="max-w-3xl mx-auto py-6 sm:px-6 lg:px-8">
        <div class="bg-gray-800 rounded-lg shadow-xl p-8 border border-gray-700">
            <h1 class="text-2xl font-bold text-white mb-6">Registrar Nueva Impresora</h1>

            <form action="<?php echo e(route('printers.store')); ?>" method="POST">
                <?php echo csrf_field(); ?>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div class="mb-4">
                        <label for="nombre" class="block text-gray-300 font-bold mb-2">Nombre Identificador</label>
                        <input type="text" name="nombre" id="nombre"
                            class="w-full bg-gray-700 border border-gray-600 rounded-md py-2 px-3 text-white focus:outline-none focus:ring-2 focus:ring-amber-500"
                            placeholder="Ej: Barra, Caja Principal" required>
                    </div>

                    <div class="mb-4">
                        <label for="tipo" class="block text-gray-300 font-bold mb-2">Tipo de Conexión</label>
                        <select name="tipo" id="tipo"
                            class="w-full bg-gray-700 border border-gray-600 rounded-md py-2 px-3 text-white focus:outline-none focus:ring-2 focus:ring-amber-500"
                            onchange="toggleIPFields()">
                            <option value="network">Red (IP)</option>
                            <option value="windows">Windows (Sistema)</option>
                            <option value="usb">USB Directo</option>
                        </select>
                    </div>
                </div>

                <div id="connectionDetails" class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                    <div id="ipContainer">
                        <label for="ip" id="ipLabel" class="block text-gray-300 font-bold mb-2">Dirección IP / Ruta</label>
                        <input type="text" name="ip" id="ip"
                            class="w-full bg-gray-700 border border-gray-600 rounded-md py-2 px-3 text-white focus:outline-none focus:ring-2 focus:ring-amber-500"
                            placeholder="192.168.1.100 o \\NombrePC\Impresora">
                        <p id="pathHint" class="text-[10px] text-gray-500 mt-1 hidden italic">
                            Para impresoras en otras computadoras: comparta la impresora y use la ruta UNC (ej:
                            \\PC-LOCAL\TM-U220).
                        </p>
                    </div>
                    <div id="portContainer">
                        <label for="puerto" class="block text-gray-300 font-bold mb-2">Puerto</label>
                        <input type="number" name="puerto" id="puerto" value="9100"
                            class="w-full bg-gray-700 border border-gray-600 rounded-md py-2 px-3 text-white focus:outline-none focus:ring-2 focus:ring-amber-500">
                    </div>
                </div>

                <div class="mb-6 flex items-center">
                    <input type="checkbox" name="es_predeterminada" id="es_predeterminada" value="1"
                        class="h-4 w-4 text-amber-500 focus:ring-amber-500 border-gray-600 rounded bg-gray-700">
                    <label for="es_predeterminada" class="ml-2 block text-sm text-gray-300">Establecer como impresora
                        predeterminada</label>
                </div>

                <div class="flex items-center justify-end space-x-4">
                    <a href="<?php echo e(route('printers.index')); ?>"
                        class="text-gray-400 hover:text-white transition-colors">Cancelar</a>
                    <button type="submit"
                        class="bg-amber-500 hover:bg-amber-400 text-gray-900 font-bold py-2 px-6 rounded shadow transition duration-150">
                        Guardar Impresora
                    </button>
                </div>
            </form>
        </div>
    </div>

    <script>
        function toggleIPFields() {
            const tipo = document.getElementById('tipo').value;
            const ipLabel = document.getElementById('ipLabel');
            const portContainer = document.getElementById('portContainer');
            const pathHint = document.getElementById('pathHint');
            const ipInput = document.getElementById('ip');

            if (tipo === 'network') {
                ipLabel.innerText = 'Dirección IP';
                ipInput.placeholder = '192.168.1.100';
                portContainer.classList.remove('hidden');
                pathHint.classList.add('hidden');
            } else {
                ipLabel.innerText = 'Ruta de Impresora (Local o Red)';
                ipInput.placeholder = '\\\\NombrePC\\Impresora';
                portContainer.classList.add('hidden');
                pathHint.classList.remove('hidden');
            }
        }
        // Init state
        window.onload = toggleIPFields;
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\SukhaCigarBar\resources\views/admin/printers/create.blade.php ENDPATH**/ ?>