

<?php $__env->startSection('content'); ?>
    <div class="max-w-7xl mx-auto py-6 sm:px-6 lg:px-8">
        <div class="flex justify-between items-center mb-6">
            <h1 class="text-3xl font-bold text-white">Categorías</h1>
            <a href="<?php echo e(route('categories.create')); ?>"
                class="bg-amber-500 hover:bg-amber-400 text-gray-900 font-bold py-2 px-4 rounded transition duration-150">
                Nueva Categoría
            </a>
        </div>

        <?php if(session('success')): ?>
            <div class="bg-green-600 text-white p-4 rounded-lg mb-6">
                <?php echo e(session('success')); ?>

            </div>
        <?php endif; ?>

        <?php if(session('error')): ?>
            <div class="bg-red-600 text-white p-4 rounded-lg mb-6">
                <?php echo e(session('error')); ?>

            </div>
        <?php endif; ?>

        <div class="bg-gray-800 rounded-lg shadow overflow-hidden border border-gray-700">
            <table class="min-w-full divide-y divide-gray-700">
                <thead class="bg-gray-700">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Nombre
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Icono
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">
                            Descripción</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-300 uppercase tracking-wider">Acciones
                        </th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-700">
                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr class="hover:bg-gray-750 transition-colors">
                            <td class="px-6 py-4 whitespace-nowrap text-white font-medium"><?php echo e($category->name); ?></td>
                            <td class="px-6 py-4 whitespace-nowrap text-gray-400 capitalize"><?php echo e($category->icon ?: 'N/A'); ?></td>
                            <td class="px-6 py-4 text-gray-400"><?php echo e($category->description ?: 'Sin descripción'); ?></td>
                            <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                                <a href="<?php echo e(route('categories.edit', $category)); ?>"
                                    class="text-amber-500 hover:text-amber-400 mr-3">Editar</a>
                                <form action="<?php echo e(route('categories.destroy', $category)); ?>" method="POST" class="inline-block"
                                    onsubmit="return confirm('¿Estás seguro de eliminar esta categoría?')">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="text-red-500 hover:text-red-400">Eliminar</button>
                                </form>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\SukhaCigarBar\resources\views/admin/categories/index.blade.php ENDPATH**/ ?>