

<?php $__env->startSection('content'); ?>
    <div class="max-w-4xl mx-auto py-8">
        <div class="flex justify-between items-center mb-6">
            <h1 class="text-3xl font-bold text-gray-100 font-serif">Configuración del Negocio</h1>
        </div>

        <form action="<?php echo e(route('admin.business.save')); ?>" method="POST" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <div class="bg-gray-800 shadow-xl rounded-lg border border-gray-700 overflow-hidden">
                <div class="p-6 space-y-6">
                    <!-- Basic Info -->
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label class="block text-sm font-medium text-gray-400 mb-2">Nombre del Negocio</label>
                            <input type="text" name="business_name"
                                value="<?php echo e(old('business_name', $config->business_name)); ?>"
                                class="w-full bg-gray-700 border border-gray-600 rounded-lg py-2 px-4 text-white focus:outline-none focus:ring-2 focus:ring-amber-500">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-400 mb-2">RNC</label>
                            <input type="text" name="rnc" value="<?php echo e(old('rnc', $config->rnc)); ?>"
                                class="w-full bg-gray-700 border border-gray-600 rounded-lg py-2 px-4 text-white focus:outline-none focus:ring-2 focus:ring-amber-500"
                                placeholder="1-23-45678-9">
                        </div>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label class="block text-sm font-medium text-gray-400 mb-2">Teléfono</label>
                            <input type="text" name="phone" value="<?php echo e(old('phone', $config->phone)); ?>"
                                class="w-full bg-gray-700 border border-gray-600 rounded-lg py-2 px-4 text-white focus:outline-none focus:ring-2 focus:ring-amber-500"
                                placeholder="(809) 000-0000">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-400 mb-2">Email</label>
                            <input type="email" name="email" value="<?php echo e(old('email', $config->email)); ?>"
                                class="w-full bg-gray-700 border border-gray-600 rounded-lg py-2 px-4 text-white focus:outline-none focus:ring-2 focus:ring-amber-500">
                        </div>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-400 mb-2">Dirección Física</label>
                        <textarea name="address" rows="3"
                            class="w-full bg-gray-700 border border-gray-600 rounded-lg py-2 px-4 text-white focus:outline-none focus:ring-2 focus:ring-amber-500"><?php echo e(old('address', $config->address)); ?></textarea>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6 items-end">
                        <div>
                            <label class="block text-sm font-medium text-gray-400 mb-2">Sitio Web</label>
                            <input type="url" name="website" value="<?php echo e(old('website', $config->website)); ?>"
                                class="w-full bg-gray-700 border border-gray-600 rounded-lg py-2 px-4 text-white focus:outline-none focus:ring-2 focus:ring-amber-500"
                                placeholder="https://sukhacigarbar.com">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-400 mb-2">Logo (Opcional)</label>
                            <div class="flex items-center space-x-4">
                                <?php if($config->logo_path): ?>
                                    <img src="<?php echo e(asset('storage/' . $config->logo_path)); ?>"
                                        class="h-10 w-10 object-contain rounded bg-gray-900 border border-gray-700">
                                <?php endif; ?>
                                <input type="file" name="logo"
                                    class="text-sm text-gray-400 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-amber-600 file:text-white hover:file:bg-amber-700">
                            </div>
                        </div>
                    </div>
                </div>

                <div class="px-6 py-4 bg-gray-900/50 border-t border-gray-700 flex justify-end">
                    <button type="submit"
                        class="bg-amber-600 hover:bg-amber-700 text-white font-bold py-2 px-6 rounded-lg transition">
                        Guardar Cambios
                    </button>
                </div>
            </div>
        </form>

        <div class="mt-8 bg-blue-900/20 border border-blue-800/50 rounded-lg p-6 flex gap-4">
            <div class="text-blue-400 text-2xl pt-1">
                <i class="bi bi-info-circle-fill"></i>
            </div>
            <div>
                <h4 class="text-blue-200 font-bold mb-1">Dato Importante</h4>
                <p class="text-sm text-blue-300/80 leading-relaxed">
                    Estos datos se utilizarán automáticamente en los encabezados de tus recibos impresos (tanto en servidor
                    como en navegador).
                    Asegúrate de que el RNC y el teléfono sean correctos.
                </p>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\SukhaCigarBar\resources\views/admin/settings/business.blade.php ENDPATH**/ ?>