

<?php $__env->startSection('content'); ?>
    <div class="min-h-screen flex items-center justify-center bg-gray-900" x-data="{
            users: <?php echo e(json_encode($users)); ?>,
            selectedUserId: '',
            hasPin: false,
            get selectedUser() {
                return this.users.find(u => u.id == this.selectedUserId) || null;
            },
            selectUser(id) {
                this.selectedUserId = id;
                const u = this.users.find(u => u.id == id);
                this.hasPin = u ? u.has_pin : false;
            }
        }">
        <div class="max-w-md w-full space-y-8 p-10 bg-gray-800 rounded-xl shadow-2xl border border-gray-700">
            <div class="text-center">
                <h2 class="mt-6 text-3xl font-extrabold text-amber-500">
                    Sukha Cigar Bar
                </h2>
                <p class="mt-2 text-sm text-gray-400">
                    Seleccione su usuario para continuar
                </p>
            </div>

            <form class="mt-8 space-y-5" action="<?php echo e(route('login')); ?>" method="POST">
                <?php echo csrf_field(); ?>

                
                <div>
                    <label for="user_id" class="block text-sm font-medium text-gray-300 mb-1">Usuario</label>
                    <select id="user_id" name="user_id" required x-model="selectedUserId"
                        @change="selectUser($event.target.value)"
                        class="appearance-none block w-full px-3 py-2 border border-gray-600 bg-gray-700 text-gray-100 rounded-md focus:outline-none focus:ring-amber-500 focus:border-amber-500 sm:text-sm">
                        <option value="" disabled selected>-- Seleccione --</option>
                        <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($user['id']); ?>" <?php echo e(old('user_id') == $user['id'] ? 'selected' : ''); ?>>
                                <?php echo e($user['name']); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <?php $__errorArgs = ['user_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="text-red-400 text-xs mt-1"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                
                <div x-show="selectedUserId !== '' && hasPin" x-transition>
                    <label for="pin" class="block text-sm font-medium text-gray-300 mb-1">PIN (4 dígitos)</label>
                    <input id="pin" name="pin" type="password" inputmode="numeric" maxlength="4" autocomplete="off"
                        class="appearance-none block w-full px-3 py-3 border border-gray-600 placeholder-gray-500 text-gray-100 bg-gray-700 rounded-md focus:outline-none focus:ring-amber-500 focus:border-amber-500 text-center text-2xl tracking-[0.5em] sm:text-sm"
                        placeholder="••••">
                    <?php $__errorArgs = ['pin'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="text-red-400 text-xs mt-1"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                
                <div x-show="selectedUserId !== '' && !hasPin" x-transition>
                    <label for="password" class="block text-sm font-medium text-gray-300 mb-1">Contraseña</label>
                    <input id="password" name="password" type="password" autocomplete="current-password"
                        class="appearance-none block w-full px-3 py-2 border border-gray-600 placeholder-gray-500 text-gray-100 bg-gray-700 rounded-md focus:outline-none focus:ring-amber-500 focus:border-amber-500 sm:text-sm"
                        placeholder="Contraseña">
                    <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="text-red-400 text-xs mt-1"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="text-red-500 text-sm text-center"><?php echo e($message); ?></div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                <div class="flex items-center">
                    <input id="remember-me" name="remember" type="checkbox"
                        class="h-4 w-4 text-amber-600 focus:ring-amber-500 border-gray-600 rounded bg-gray-700">
                    <label for="remember-me" class="ml-2 block text-sm text-gray-400">
                        Recordarme
                    </label>
                </div>

                <div>
                    <button type="submit"
                        class="group relative w-full flex justify-center py-2 px-4 border border-transparent text-sm font-medium rounded-md text-gray-900 bg-amber-500 hover:bg-amber-400 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-amber-500 transition duration-150 ease-in-out">
                        <span class="absolute left-0 inset-y-0 flex items-center pl-3">
                            <svg class="h-5 w-5 text-amber-900 group-hover:text-amber-800"
                                xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor"
                                aria-hidden="true">
                                <path fill-rule="evenodd"
                                    d="M5 9V7a5 5 0 0110 0v2a2 2 0 012 2v5a2 2 0 01-2 2H5a2 2 0 01-2-2v-5a2 2 0 012-2zm8-2v2H7V7a3 3 0 016 0z"
                                    clip-rule="evenodd" />
                            </svg>
                        </span>
                        Ingresar
                    </button>
                </div>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\SukhaCigarBar\resources\views/auth/login.blade.php ENDPATH**/ ?>