

<?php $__env->startSection('content'); ?>
    <div class="max-w-7xl mx-auto py-6 sm:px-6 lg:px-8">
        <div class="flex justify-between items-center mb-6">
            <div>
                <h1 class="text-3xl font-bold text-white">Detección Automática</h1>
                <p class="text-gray-400 text-sm mt-1">Escaneando impresoras locales (USB), de sistema y de red...</p>
            </div>
            <a href="<?php echo e(route('printers.index')); ?>" class="text-gray-400 hover:text-white transition">Volver</a>
        </div>

        <?php if(count($discovered) > 0): ?>
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                <?php $__currentLoopData = $discovered; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $idx => $printer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div
                        class="bg-gray-800 rounded-lg p-6 border border-gray-700 shadow-lg hover:border-amber-500 transition-all group">
                        <div class="flex items-start justify-between">
                            <div
                                class="p-3 bg-gray-700 rounded-lg text-amber-500 group-hover:bg-amber-500 group-hover:text-gray-900 transition flex items-center justify-center">
                                <?php if($printer['tipo'] == 'network'): ?>
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24"
                                        stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M3.055 11H5a2 2 0 012 2v1a2 2 0 002 2 2 2 0 012 2v2.945M8 3.935V5.5A2.5 2.5 0 0010.5 8h.5a2 2 0 012 2 2 2 0 104 0 2 2 0 012-2h1.064M15 20.488V18a2 2 0 012-2h3.064M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                                    </svg>
                                <?php else: ?>
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24"
                                        stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M9 3v2m6-2v2M9 19v2m6-2v2M5 9H3m2 6H3m18-6h-2m2 6h-2M7 19h10a2 2 0 002-2V7a2 2 0 00-2-2H7a2 2 0 00-2 2v10a2 2 0 002 2zM9 9h6v6H9V9z" />
                                    </svg>
                                <?php endif; ?>
                            </div>
                            <span
                                class="text-[10px] font-bold px-2 py-1 bg-gray-700 text-gray-400 rounded uppercase"><?php echo e($printer['tipo']); ?></span>
                        </div>

                        <h3 class="mt-4 text-white font-bold text-lg truncate"><?php echo e($printer['nombre']); ?></h3>
                        <p class="text-xs text-gray-500 mt-1"><?php echo e($printer['detalles']); ?></p>

                        <div class="mt-6">
                            <form action="<?php echo e(route('printers.store')); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="nombre" value="<?php echo e($printer['nombre']); ?>">
                                <input type="hidden" name="tipo" value="<?php echo e($printer['tipo']); ?>">
                                <input type="hidden" name="ip" value="<?php echo e($printer['ip']); ?>">
                                <input type="hidden" name="puerto" value="<?php echo e($printer['puerto'] ?? 9100); ?>">

                                <button type="submit"
                                    class="w-full bg-amber-500 hover:bg-amber-400 text-gray-900 font-bold py-2 rounded text-sm shadow transition">
                                    Registrar Esta Impresora
                                </button>
                            </form>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        <?php else: ?>
            <div class="bg-gray-800 rounded-lg p-12 border border-gray-700 text-center">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-16 w-16 text-gray-600 mx-auto mb-4" fill="none"
                    viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                        d="M18.364 5.636l-3.536 3.536m0 5.656l3.536 3.536M9.172 9.172L5.636 5.636m3.536 9.192l-3.536 3.536M21 12a9 9 0 11-18 0 9 9 0 0118 0zm-5 0a4 4 0 11-8 0 4 4 0 018 0z" />
                </svg>
                <h2 class="text-xl font-bold text-white">No se detectaron nuevas impresoras</h2>
                <p class="text-gray-400 mt-2 max-w-sm mx-auto">Asegúrate de que la impresora esté encendida, conectada por USB o
                    en la misma red que este servidor.</p>
                <a href="<?php echo e(route('printers.discover')); ?>"
                    class="mt-6 inline-block bg-amber-500 hover:bg-amber-400 text-gray-900 font-bold py-2 px-6 rounded transition">
                    Reintentar Búsqueda
                </a>
            </div>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\SukhaCigarBar\resources\views/admin/printers/discover.blade.php ENDPATH**/ ?>