

<?php $__env->startSection('content'); ?>
    <div class="max-w-7xl mx-auto py-6 sm:px-6 lg:px-8" x-data="{ activeTab: 'all' }">
        <div class="flex justify-between items-center mb-6 px-4 sm:px-0">
            <h1 class="text-2xl font-bold text-gray-100">Gestión de Productos</h1>
            <a href="<?php echo e(route('products.create')); ?>"
                class="inline-flex items-center px-4 py-2 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-amber-600 hover:bg-amber-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-amber-500">
                Nuevo Producto
            </a>
        </div>

        <?php if(session('success')): ?>
            <div class="mb-4 bg-green-900 border-l-4 border-green-500 p-4 mx-4 sm:mx-0">
                <p class="text-sm text-green-300"><?php echo e(session('success')); ?></p>
            </div>
        <?php endif; ?>

        <!-- Category Tabs -->
        <div class="mb-6 flex flex-wrap gap-2 px-4 sm:px-0">
            <button @click="activeTab = 'all'"
                :class="activeTab === 'all' ? 'bg-amber-600 text-white' : 'bg-gray-700 text-gray-300 hover:bg-gray-600'"
                class="px-4 py-2 rounded-full text-sm font-bold transition-colors">
                Todo
            </button>
            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <button @click="activeTab = <?php echo e($category->id); ?>"
                    :class="activeTab === <?php echo e($category->id); ?> ? 'bg-amber-600 text-white' : 'bg-gray-700 text-gray-300 hover:bg-gray-600'"
                    class="px-4 py-2 rounded-full text-sm font-bold transition-colors">
                    <?php echo e($category->name); ?>

                </button>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>

        <div class="bg-gray-800 shadow overflow-hidden sm:rounded-lg border border-gray-700 mx-4 sm:mx-0">
            <table class="min-w-full divide-y divide-gray-700">
                <thead class="bg-gray-900">
                    <tr>
                        <th scope="col"
                            class="px-6 py-3 text-left text-xs font-medium text-gray-400 uppercase tracking-wider">Nombre /
                            Categoría</th>
                        <th scope="col"
                            class="px-6 py-3 text-left text-xs font-medium text-gray-400 uppercase tracking-wider">Precios
                            (C/V)</th>
                        <th scope="col"
                            class="px-6 py-3 text-left text-xs font-medium text-gray-400 uppercase tracking-wider text-center">Estado</th>
                        <th scope="col"
                            class="px-6 py-3 text-left text-xs font-medium text-gray-400 uppercase tracking-wider">Stock
                        </th>
                        <th scope="col"
                            class="px-6 py-3 text-right text-xs font-medium text-gray-400 uppercase tracking-wider">Acciones
                        </th>
                    </tr>
                </thead>
                <tbody class="bg-gray-800 divide-y divide-gray-700">
                    <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr x-show="activeTab === 'all' || activeTab === <?php echo e($product->category_id); ?>" x-transition>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="flex items-center">
                                    <div class="h-10 w-10 flex-shrink-0 mr-3">
                                        <img class="h-10 w-10 rounded-lg object-cover border border-gray-700 bg-gray-900" 
                                             src="<?php echo e($product->image_url ? (str_starts_with($product->image_url, 'http') ? $product->image_url : asset($product->image_url)) : 'https://images.unsplash.com/photo-1527661591475-527312dd65f5?q=80&w=500&auto=format&fit=crop'); ?>" 
                                             alt="">
                                    </div>
                                    <div>
                                        <div class="text-sm font-medium text-white"><?php echo e($product->name); ?></div>
                                        <div class="text-sm text-gray-400"><?php echo e($product->category->name); ?></div>
                                    </div>
                                </div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="text-sm text-gray-300">C: RD$<?php echo e(number_format($product->purchase_price, 2)); ?></div>
                                <div class="text-sm text-amber-500 font-bold">V: RD$<?php echo e(number_format($product->sale_price, 2)); ?>

                                </div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-center">
                                <?php if($product->is_active): ?>
                                    <span class="px-2 py-1 text-[10px] font-bold bg-green-900/50 text-green-400 rounded-full border border-green-800">ACTIVO</span>
                                <?php else: ?>
                                    <span class="px-2 py-1 text-[10px] font-bold bg-red-900/50 text-red-400 rounded-full border border-red-800">INACTIVO</span>
                                <?php endif; ?>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <span
                                    class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full <?php echo e($product->stock <= $product->min_stock ? 'bg-red-900 text-red-200' : 'bg-green-900 text-green-200'); ?>">
                                    <?php echo e($product->stock); ?>

                                </span>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                                <a href="<?php echo e(route('products.edit', $product)); ?>"
                                    class="text-amber-400 hover:text-amber-300 mr-3">Editar</a>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\SukhaCigarBar\resources\views/products/index.blade.php ENDPATH**/ ?>