

<?php $__env->startSection('content'); ?>
    <div class="h-screen flex flex-col bg-gray-900 overflow-hidden" id="designer-app" x-data="designerApp()" x-cloak>
        <!-- Header -->
        <div class="bg-gray-800 border-b border-gray-700 px-6 py-3 flex justify-between items-center">
            <div class="flex items-center space-x-6">
                <div>
                    <h1 class="text-xl font-bold text-white">Diseñador de Recibos</h1>
                    <p class="text-xs text-gray-400">Personaliza el formato de impresión</p>
                </div>
                <div class="flex bg-gray-900 rounded-lg p-1 border border-gray-700">
                    <button @click="changeType('factura')"
                        :class="template.tipo == 'factura' ? 'bg-amber-600 text-white shadow-lg' : 'text-gray-400 hover:text-white'"
                        class="px-4 py-1.5 text-xs font-bold rounded-md transition-all">Factura</button>
                    <button @click="changeType('precuenta')"
                        :class="template.tipo == 'precuenta' ? 'bg-amber-600 text-white shadow-lg' : 'text-gray-400 hover:text-white'"
                        class="px-4 py-1.5 text-xs font-bold rounded-md transition-all">Pre-Cuenta</button>
                </div>
            </div>
            <div class="flex items-center space-x-4">
                <span x-show="saving" class="text-amber-500 text-xs animate-pulse">Guardando cambios...</span>
                <button @click="saveTemplate()"
                    class="bg-amber-600 hover:bg-amber-500 text-white font-bold py-2 px-8 rounded-xl shadow-lg transition transform hover:scale-105 active:scale-95">
                    Guardar Configuración
                </button>
            </div>
        </div>

        <!-- Main Content -->
        <div class="flex-grow flex overflow-hidden">
            <!-- Left Panel: Blocks & Ordering -->
            <div class="w-80 bg-gray-800 border-r border-gray-700 flex flex-col overflow-hidden">
                <div class="p-4 border-b border-gray-700 flex justify-between items-center bg-gray-800/50">
                    <h2 class="text-xs font-bold text-gray-400 uppercase tracking-widest">Estructura</h2>
                    <button @click="addTextBlock()" class="text-amber-500 hover:text-amber-400 text-xs font-bold">+
                        Texto</button>
                </div>

                <div class="flex-grow overflow-y-auto p-4 space-y-2 custom-scrollbar">
                    <template x-for="(block, index) in template.estructura_json.bloques" :key="block.id">
                        <div class="group relative bg-gray-900 rounded-xl p-3 border transition-all duration-200"
                            :class="selectedId === block.id ? 'border-amber-500 shadow-lg shadow-amber-900/20' : 'border-gray-700 hover:border-gray-500'">

                            <div class="flex items-center justify-between gap-2">
                                <div class="flex items-center gap-2 cursor-pointer flex-grow"
                                    @click="selectedId = block.id">
                                    <div class="bg-gray-800 p-1.5 rounded-lg">
                                        <i class="bi text-xs text-amber-500" :class="getBlockIcon(block.type)"></i>
                                    </div>
                                    <span class="text-xs font-bold text-gray-200 truncate"
                                        x-text="getBlockLabel(block)"></span>
                                </div>

                                <div class="flex items-center opacity-0 group-hover:opacity-100 transition-opacity">
                                    <button @click="moveBlock(index, -1)" :disabled="index === 0"
                                        class="p-1 text-gray-500 hover:text-white disabled:opacity-0">
                                        <i class="bi bi-chevron-up"></i>
                                    </button>
                                    <button @click="moveBlock(index, 1)"
                                        :disabled="index === template.estructura_json.bloques.length - 1"
                                        class="p-1 text-gray-500 hover:text-white disabled:opacity-0">
                                        <i class="bi bi-chevron-down"></i>
                                    </button>
                                    <button @click="removeBlock(index)" x-show="['text', 'divider'].includes(block.type)"
                                        class="p-1 text-red-500 hover:text-red-400">
                                        <i class="bi bi-trash"></i>
                                    </button>
                                </div>

                                <input type="checkbox" x-model="block.active"
                                    class="ml-2 h-4 w-4 text-amber-600 bg-gray-800 border-gray-600 rounded">
                            </div>
                        </div>
                    </template>
                </div>
            </div>

            <!-- Center: Live Preview (80mm) -->
            <div class="flex-grow bg-[#1a1c23] p-8 flex justify-center overflow-y-auto">
                <div class="receipt-paper bg-white text-black p-6 shadow-2xl relative mb-20"
                    style="width: 300px; min-height: 500px; font-family: 'Courier New', Courier, monospace; font-size: 13px; line-height: 1.3;">

                    <div
                        class="absolute top-0 left-0 w-full h-1 bg-gradient-to-r from-transparent via-gray-200 to-transparent">
                    </div>

                    <template x-for="block in template.estructura_json.bloques" :key="block.id">
                        <div x-show="block.active"
                            class="preview-block py-0.5 border-b border-transparent hover:border-blue-100 transition-colors"
                            :style="{ textAlign: block.align || 'left' }">

                            <!-- Header Info -->
                            <template x-if="block.type === 'header'">
                                <div class="space-y-0.5">
                                    <p class="font-bold text-base">SUKHA CIGAR BAR & LOUNGE</p>
                                    <p>Av. Principal #123</p>
                                    <p>Tel: (809) 555-0199</p>
                                    <p>RNC: 123-45678-9</p>
                                </div>
                            </template>

                            <!-- Plain Text -->
                            <template x-if="block.type === 'text'">
                                <p :class="block.bold ? 'font-bold' : ''"
                                    :style="{ fontSize: block.font_size === 'small' ? '10px' : '13px' }"
                                    x-text="block.content"></p>
                            </template>

                            <!-- Divider -->
                            <template x-if="block.type === 'divider'">
                                <div class="py-1">
                                    <p
                                        x-text="block.style === 'double' ? '============================' : '----------------------------'">
                                    </p>
                                </div>
                            </template>

                            <!-- Data Fields -->
                            <template x-if="block.type === 'data_field'">
                                <p><span x-text="block.label"></span><span class="font-bold"
                                        x-text="getSampleValue(block.field)"></span></p>
                            </template>

                            <!-- Items Table -->
                            <template x-if="block.type === 'items_table'">
                                <div class="my-2">
                                    <div class="flex font-bold border-b border-black">
                                        <span class="w-8">Ct</span>
                                        <span class="flex-grow">Producto</span>
                                        <span class="w-16 text-right">Total</span>
                                    </div>
                                    <div class="flex py-0.5">
                                        <span class="w-8">1</span>
                                        <span class="flex-grow">Cigarro Fuente...</span>
                                        <span class="w-16 text-right">720.34</span>
                                    </div>
                                    <div class="flex py-0.5">
                                        <span class="w-8">2</span>
                                        <span class="flex-grow">Brugal Extra...</span>
                                        <span class="w-16 text-right">1,016.95</span>
                                    </div>
                                </div>
                            </template>

                            <!-- Totals -->
                            <template x-if="block.type === 'totals'">
                                <div class="text-right space-y-0.5 mt-2">
                                    <p>SUBTOTAL: 1,737.29</p>
                                    <p>ITBIS (18.00%): 312.71</p>
                                    <p class="font-bold text-sm">TOTAL RD$: 2,050.00</p>
                                </div>
                            </template>

                            <!-- QR Code -->
                            <template x-if="block.type === 'qr_code'">
                                <div class="my-4 flex flex-col items-center">
                                    <div class="w-20 h-20 border-2 border-black flex items-center justify-center p-2">
                                        <i class="bi bi-qr-code text-4xl"></i>
                                    </div>
                                    <p class="text-[8px] mt-1">Sukhacigarbar.com</p>
                                </div>
                            </template>
                        </div>
                    </template>
                </div>
            </div>

            <!-- Right Panel: Editor -->
            <div class="w-80 bg-gray-800 border-l border-gray-700 p-6 flex flex-col overflow-hidden">
                <template x-if="selectedBlock">
                    <div class="space-y-6">
                        <div class="flex items-center gap-3 border-b border-gray-700 pb-4">
                            <div class="bg-amber-600/20 p-2 rounded-lg">
                                <i class="bi text-xl text-amber-500" :class="getBlockIcon(selectedBlock.type)"></i>
                            </div>
                            <div>
                                <h3 class="font-bold text-white" x-text="getBlockLabel(selectedBlock)"></h3>
                                <p class="text-[10px] text-gray-500 uppercase tracking-tighter">Propiedades del bloque</p>
                            </div>
                        </div>

                        <!-- Alignment -->
                        <div class="space-y-2">
                            <label class="text-[10px] font-bold text-gray-500 uppercase">Alineación</label>
                            <div class="grid grid-cols-3 gap-2 bg-gray-900 p-1 rounded-xl">
                                <button @click="selectedBlock.align = 'left'"
                                    :class="selectedBlock.align === 'left' ? 'bg-gray-700 text-amber-500 shadow-inner' : 'text-gray-500'"
                                    class="py-2 rounded-lg transition-all"><i class="bi bi-text-left"></i></button>
                                <button @click="selectedBlock.align = 'center'"
                                    :class="selectedBlock.align === 'center' ? 'bg-gray-700 text-amber-500 shadow-inner' : 'text-gray-500'"
                                    class="py-2 rounded-lg transition-all"><i class="bi bi-text-center"></i></button>
                                <button @click="selectedBlock.align = 'right'"
                                    :class="selectedBlock.align === 'right' ? 'bg-gray-700 text-amber-500 shadow-inner' : 'text-gray-500'"
                                    class="py-2 rounded-lg transition-all"><i class="bi bi-text-right"></i></button>
                            </div>
                        </div>

                        <!-- Content Specific Editors -->
                        <div x-show="selectedBlock.type === 'text'" class="space-y-4">
                            <div>
                                <label class="text-[10px] font-bold text-gray-400">Contenido del Texto</label>
                                <textarea x-model="selectedBlock.content"
                                    class="w-full bg-gray-900 border border-gray-700 rounded-xl p-3 text-sm text-white focus:border-amber-500 outline-none"
                                    rows="4"></textarea>
                            </div>
                            <div class="flex items-center justify-between">
                                <span class="text-xs text-gray-300">Negrita (Bold)</span>
                                <input type="checkbox" x-model="selectedBlock.bold"
                                    class="h-4 w-4 text-amber-500 rounded bg-gray-900 border-gray-700">
                            </div>
                        </div>

                        <div x-show="selectedBlock.type === 'data_field'" class="space-y-4">
                            <div>
                                <label class="text-[10px] font-bold text-gray-400">Etiqueta (Label)</label>
                                <input type="text" x-model="selectedBlock.label"
                                    class="w-full bg-gray-900 border border-gray-700 rounded-xl p-3 text-sm text-white focus:border-amber-500 outline-none">
                            </div>
                        </div>

                        <div x-show="selectedBlock.type === 'divider'" class="space-y-4">
                            <label class="text-[10px] font-bold text-gray-400">Estilo de Línea</label>
                            <select x-model="selectedBlock.style"
                                class="w-full bg-gray-900 border border-gray-700 rounded-xl p-3 text-sm text-white focus:border-amber-500 outline-none">
                                <option value="dashed">Sencilla (----)</option>
                                <option value="double">Doble (====)</option>
                            </select>
                        </div>
                    </div>
                </template>

                <div x-show="!selectedId" class="flex-grow flex flex-col space-y-6">
                    <div
                        class="flex-grow flex flex-col items-center justify-center text-center p-6 bg-gray-900/40 rounded-3xl border border-dashed border-gray-700">
                        <div class="text-4xl text-gray-700 mb-4 animate-bounce">👈</div>
                        <p class="text-gray-500 text-sm">Selecciona un bloque a la izquierda para configurar sus detalles.
                        </p>
                    </div>

                    <!-- Variables Cheat Sheet -->
                    <div class="bg-indigo-900/20 border border-indigo-500/20 rounded-2xl p-4">
                        <div class="flex items-center gap-2 mb-3">
                            <i class="bi bi-info-circle text-indigo-400 text-xs"></i>
                            <h4 class="text-[10px] font-bold text-indigo-300 uppercase tracking-widest">Variables de Texto
                            </h4>
                        </div>
                        <div class="grid grid-cols-2 gap-2 text-[9px] text-gray-400">
                            <div><span class="text-indigo-400">{MESA}</span>: Nombre mesa</div>
                            <div><span class="text-indigo-400">{ORDEN}</span>: # Orden</div>
                            <div><span class="text-indigo-400">{FECHA}</span>: Fecha hoy</div>
                            <div><span class="text-indigo-400">{HORA}</span>: Hora actual</div>
                            <div><span class="text-indigo-400">{TOTAL}</span>: Monto total</div>
                            <div><span class="text-indigo-400">{MESERO}</span>: Quién atiende</div>
                        </div>
                        <p class="mt-3 text-[8px] text-gray-500 italic">Puedes usarlas dentro de cualquier bloque de Texto.
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        function designerApp() {
            return {
                template: <?php echo json_encode($template, 15, 512) ?>,
                selectedId: null,
                saving: false,

                get selectedBlock() {
                    return this.template.estructura_json.bloques.find(b => b.id === this.selectedId);
                },

                getBlockIcon(type) {
                    return {
                        'header': 'bi-building',
                        'text': 'bi-justify-left',
                        'divider': 'bi-dash-lg',
                        'data_field': 'bi-hash',
                        'items_table': 'bi-list-ul',
                        'totals': 'bi-calculator',
                        'qr_code': 'bi-qr-code'
                    }[type] || 'bi-square';
                },

                getBlockLabel(block) {
                    if (block.type === 'text') return block.content.substring(0, 15) + (block.content.length > 15 ? '...' : '');
                    if (block.type === 'data_field') return block.field.toUpperCase();
                    return block.type.replace('_', ' ').toUpperCase();
                },

                getSampleValue(field) {
                    return {
                        'ncf': 'B0100000001',
                        'id': '000123',
                        'orden': '#00123',
                        'fecha': '12/02/2026',
                        'hora': '15:30',
                        'mesa': 'Terraza 1',
                        'cajero': 'Admin',
                        'mesero': 'Carlos M.',
                        'usuario': 'Admin',
                        'cliente': 'Juan Perez',
                        'total': 'RD$ 2,500.00'
                    }[field] || 'SAMPLE';
                },

                moveBlock(index, direction) {
                    const blocks = this.template.estructura_json.bloques;
                    const newIndex = index + direction;
                    if (newIndex >= 0 && newIndex < blocks.length) {
                        const temp = blocks[index];
                        blocks[index] = blocks[newIndex];
                        blocks[newIndex] = temp;
                    }
                },

                addTextBlock() {
                    const newBlock = {
                        id: 'b' + Date.now(),
                        type: 'text',
                        active: true,
                        content: 'NUEVO TEXTO',
                        align: 'center',
                        bold: false
                    };
                    this.template.estructura_json.bloques.push(newBlock);
                    this.selectedId = newBlock.id;
                },

                removeBlock(index) {
                    if (confirm('¿Eliminar este bloque?')) {
                        this.template.estructura_json.bloques.splice(index, 1);
                        this.selectedId = null;
                    }
                },

                changeType(type) {
                    window.location.href = "<?php echo e(route('designer.index')); ?>?tipo=" + type;
                },

                async saveTemplate() {
                    this.saving = true;
                    try {
                        const response = await fetch("<?php echo e(route('designer.save')); ?>", {
                            method: 'POST',
                            headers: {
                                'Content-Type': 'application/json',
                                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                            },
                            body: JSON.stringify(this.template)
                        });
                        const data = await response.json();
                        if (data.success) {
                            this.template.id = data.template.id;
                            // Notification could be better but sticking to alert for simplicity or success message
                        }
                    } catch (error) {
                        console.error('Error saving template:', error);
                    } finally {
                        this.saving = false;
                    }
                }
            }
        }
    </script>

    <style>
        [x-cloak] {
            display: none !important;
        }

        .receipt-paper {
            border-bottom: 8px solid transparent;
            border-image: url('data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" width="10" height="10" viewBox="0 0 10 10"><path d="M0,0 L5,5 L10,0 L10,10 L0,10 Z" fill="white"/></svg>') 10 repeat;
        }

        .custom-scrollbar::-webkit-scrollbar {
            width: 4px;
        }

        .custom-scrollbar::-webkit-scrollbar-track {
            background: #1f2937;
        }

        .custom-scrollbar::-webkit-scrollbar-thumb {
            background: #4b5563;
            border-radius: 10px;
        }
    </style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\SukhaCigarBar\resources\views/admin/templates/designer.blade.php ENDPATH**/ ?>