<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\CajaController;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\CategoryController;
use App\Http\Controllers\InventoryController;
use App\Http\Controllers\TableController;
use App\Http\Controllers\OrderController;
use App\Http\Controllers\POSController;
use App\Http\Controllers\EmployeeController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\PublicMenuController;
use App\Http\Controllers\PrinterController;
use App\Http\Controllers\TemplateDesignerController;
use App\Http\Controllers\MesaManagementController;
use App\Http\Controllers\MenuConfigController;
use App\Http\Controllers\BusinessConfigController;

Route::get('/', function () {
    return redirect()->route('login');
});

Route::get('/login', [AuthController::class, 'showLoginForm'])->name('login');
Route::post('/login', [AuthController::class, 'login']);
Route::post('/logout', [AuthController::class, 'logout'])->name('logout');

// Digital Menu (Public)
Route::get('/menu', [PublicMenuController::class, 'index'])->name('public.menu');

Route::middleware(['auth'])->group(function () {
    Route::get('/admin/dashboard', [AdminController::class, 'index'])->name('admin.dashboard');

    Route::get('/caja/operations', [CajaController::class, 'index'])->name('caja.operations');
    Route::post('/caja/open', [CajaController::class, 'open'])->name('caja.open.post');
    Route::get('/caja/close', [CajaController::class, 'showCloseForm'])->name('caja.close');
    Route::post('/caja/close', [CajaController::class, 'close'])->name('caja.close.post');
    Route::get('/caja/summary/{arqueo}', [CajaController::class, 'summary'])->name('caja.summary');

    // Products & Categories
    Route::resource('products', ProductController::class);
    Route::resource('categories', CategoryController::class);

    // Inventory
    Route::get('/inventory', [InventoryController::class, 'index'])->name('inventory.index');
    Route::post('/inventory/adjust', [InventoryController::class, 'adjust'])->name('inventory.adjust');

    // POS (Table Management)
    Route::get('/pos', [TableController::class, 'index'])->name('pos.index');
    Route::get('/pos/map', [TableController::class, 'index'])->name('pos.map');
    Route::post('/pos/table/{mesa}/open', [TableController::class, 'open'])->name('pos.table.open');
    Route::get('/pos/table/{mesa}', [TableController::class, 'show'])->name('pos.table.show');

    // Order Actions
    Route::post('/pos/order/{orden}/add', [OrderController::class, 'addItem'])->name('pos.order.addItem');
    Route::delete('/pos/order/item/{detalle}', [OrderController::class, 'removeItem'])->name('pos.order.removeItem');
    Route::delete('/pos/order/{orden}/cancel', [OrderController::class, 'cancel'])->name('pos.order.cancel');
    Route::post('/pos/order/{orden}/precheck', [OrderController::class, 'printPreCheck'])->name('pos.order.precheck');
    Route::get('/pos/order/{orden}/print-browser', [OrderController::class, 'printTicket'])->name('pos.order.print-browser');
    Route::post('/pos/order/{orden}/close', [OrderController::class, 'closeTable'])->name('pos.order.close');
    Route::post('/order/{orden}/split', [OrderController::class, 'splitPayment'])->name('order.split');
    Route::post('/order/{orden}/split-amount', [OrderController::class, 'payPartialAmount'])->name('order.split-amount');
    Route::patch('/pos/order/{orden}/cliente', [OrderController::class, 'updateCliente'])->name('pos.order.updateCliente');

    // POS Search (AJAX)
    Route::get('/pos/search', [POSController::class, 'search'])->name('pos.search');

    // Employees
    Route::resource('employees', EmployeeController::class)->middleware('can:isAdmin');

    // Reports
    Route::get('/admin/reports/daily-sales', [ReportController::class, 'dailySales'])->name('reports.daily_sales')->middleware('can:isAdmin');
    Route::get('/admin/reports/product-sales', [ReportController::class, 'productSales'])->name('reports.product_sales')->middleware('can:isAdmin');
    Route::get('/admin/reports/inventory', [ReportController::class, 'inventory'])->name('reports.inventory')->middleware('can:isAdmin');
    Route::get('/admin/reports/inventory/print', [ReportController::class, 'inventoryPrint'])->name('reports.inventory.print')->middleware('can:isAdmin');

    // Digital Menu (Public) - MOVED OUTSIDE AUTH

    // Admin Restricted Area
    Route::middleware(['can:isAdmin'])->group(function () {
        // Printers
        Route::get('/printers/discover', [PrinterController::class, 'discover'])->name('printers.discover');
        Route::resource('printers', PrinterController::class);
        Route::post('/printers/{printer}/default', [PrinterController::class, 'setDefault'])->name('printers.default');

        // Receipt Designer
        Route::get('/designer', [TemplateDesignerController::class, 'index'])->name('designer.index');
        Route::post('/designer/save', [TemplateDesignerController::class, 'save'])->name('designer.save');

        // Table & Zone Management
        Route::get('/admin/mesas-gestion', [MesaManagementController::class, 'index'])->name('admin.mesas.index');
        Route::post('/admin/zonas', [MesaManagementController::class, 'storeZona'])->name('admin.zonas.store');
        Route::post('/admin/mesas', [MesaManagementController::class, 'storeMesa'])->name('admin.mesas.store');
        Route::put('/admin/mesas/{mesa}', [MesaManagementController::class, 'updateMesa'])->name('admin.mesas.update');
        Route::delete('/admin/zonas/{zona}', [MesaManagementController::class, 'destroyZona'])->name('admin.zonas.destroy');
        Route::delete('/admin/mesas/{mesa}', [MesaManagementController::class, 'destroyMesa'])->name('admin.mesas.destroy');

        // Menu Designer
        Route::get('/admin/menu-designer', [MenuConfigController::class, 'index'])->name('admin.menu.designer');
        Route::post('/admin/menu-designer/save', [MenuConfigController::class, 'save'])->name('admin.menu.save');

        // Business Settings
        Route::get('/admin/settings/business', [BusinessConfigController::class, 'index'])->name('admin.business.index');
        Route::post('/admin/settings/business/save', [BusinessConfigController::class, 'save'])->name('admin.business.save');
    });
});
