<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ticket - {{ $tipo === 'factura' ? 'Factura' : 'Pre-Cuenta' }}</title>
    <style>
        @page {
            margin: 0;
            size: 80mm auto;
            /* Standard thermal width */
        }

        body {
            font-family: 'Courier New', Courier, monospace;
            font-size: 12px;
            margin: 0;
            padding: 5mm;
            width: 70mm;
            /* Account for padding */
            background-color: white;
            color: black;
        }

        .header {
            text-align: center;
            margin-bottom: 5mm;
        }

        .header h1 {
            font-size: 18px;
            margin: 0;
            text-transform: uppercase;
        }

        .divider {
            border-bottom: 1px dashed black;
            margin: 3mm 0;
        }

        .info-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 1mm;
        }

        .items-table {
            width: 100%;
            border-collapse: collapse;
            margin: 3mm 0;
        }

        .items-table th {
            text-align: left;
            border-bottom: 1px solid black;
            padding-bottom: 1mm;
        }

        .items-table td {
            padding: 1mm 0;
            vertical-align: top;
        }

        .text-right {
            text-align: right;
        }

        .bold {
            font-weight: bold;
        }

        .totals {
            margin-top: 5mm;
        }

        .footer {
            text-align: center;
            margin-top: 10mm;
            font-size: 10px;
        }

        @media print {
            .no-print {
                display: none;
            }

            body {
                padding: 0;
            }
        }

        .print-btn {
            position: fixed;
            top: 10px;
            right: 10px;
            padding: 10px 20px;
            background: #f59e0b;
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-family: sans-serif;
            font-weight: bold;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.2);
        }
    </style>
</head>

<body>
    <button class="no-print print-btn" onclick="window.print()">IMPRIMIR TICKET</button>

    <div class="header">
        <h1>{{ $config->business_name }}</h1>
        @if($config->rnc)
        <p>RNC: {{ $config->rnc }}</p> @endif
        @if($config->address)
        <p>{{ $config->address }}</p> @endif
        @if($config->phone)
        <p>Tel: {{ $config->phone }}</p> @endif
    </div>

    <div class="divider"></div>

    <div class="header">
        @if($orden->mesa->is_internal)
            <h2 style="margin:0; background: #000; color: #fff; padding: 2px;">USO INTERNO</h2>
        @endif
        <h2 style="margin:0">{{ $tipo === 'factura' ? 'FACTURA' : 'PRE-CUENTA' }}</h2>
    </div>

    <div class="info-row">
        <span>Fecha:</span>
        <span>{{ now()->format('d/m/Y') }}</span>
    </div>
    <div class="info-row">
        <span>Hora:</span>
        <span>{{ now()->format('h:i A') }}</span>
    </div>
    <div class="info-row">
        <span>Mesa:</span>
        <span class="bold">{{ $orden->mesa->name }}</span>
    </div>
    <div class="info-row">
        <span>Atendido por:</span>
        <span>{{ Auth::user()->name }}</span>
    </div>
    @if($orden->cliente)
        <div class="info-row">
            <span>Cliente:</span>
            <span>{{ $orden->cliente }}</span>
        </div>
    @endif
    @if($sale && $sale->id)
        <div class="info-row">
            <span>Factura #:</span>
            <span class="bold">{{ $sale->id }}</span>
        </div>
    @endif

    <div class="divider"></div>

    <table class="items-table">
        <thead>
            <tr>
                <th width="15%">Cant</th>
                <th width="55%">Desc.</th>
                <th width="30%" class="text-right">Total</th>
            </tr>
        </thead>
        <tbody>
            @foreach($orden->detalles as $detalle)
                <tr>
                    <td>{{ number_format($detalle->cantidad, 0) }}</td>
                    <td>
                        {{ $detalle->product->name }}
                        @if($detalle->observaciones)
                            <br><small>* {{ $detalle->observaciones }}</small>
                        @endif
                    </td>
                    <td class="text-right">{{ number_format($detalle->subtotal / 1.18, 2) }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>

    <div class="divider"></div>

    <div class="totals">
        <div class="info-row">
            <span>Subtotal:</span>
            <span>{{ number_format($orden->total / 1.18, 2) }}</span>
        </div>
        <div class="info-row">
            <span>ITBIS (18%):</span>
            <span>{{ number_format($orden->total - ($orden->total / 1.18), 2) }}</span>
        </div>
        <div class="info-row bold" style="font-size: 14px; margin-top:2mm;">
            <span>TOTAL RD$:</span>
            <span>{{ number_format($orden->total, 2) }}</span>
        </div>
    </div>

    @if($sale)
        <div class="divider"></div>
        <div class="info-row">
            <span>Pagado con:</span>
            <span style="text-transform:capitalize">{{ $sale->payment_method }}</span>
        </div>
        <div class="info-row">
            <span>Entregado:</span>
            <span>{{ number_format($sale->amount_paid, 2) }}</span>
        </div>
        <div class="info-row">
            <span>Cambio:</span>
            <span>{{ number_format($sale->change_given, 2) }}</span>
        </div>
    @endif

    <div class="divider"></div>

    <div class="footer">
        <p>¡GRACIAS POR SU PREFERENCIA!</p>
        <p>@Sukhacigarbar</p>
        <p>Visítanos pronto</p>
    </div>

    <script>
        // Auto print and close tab
        window.onload = function () {
            window.print();

            // Listen for afterprint event - most reliable way to know print/cancel happened
            window.onafterprint = function () {
                window.close();
            };

            // Fallback: if afterprint doesn't fire (some browsers), close after 2 seconds
            setTimeout(function () {
                // Check if window is still open
                if (!window.closed) {
                    // window.close();
                }
            }, 2000);
        }
    </script>
</body>

</html>