<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Sukha Cigar Bar & Lounge</title>
    <!-- Tailwind CSS (via CDN for simplicity as requested, or Vite if installed) -->
    <!-- Using CDN for now to ensure immediate specific visual results without build steps, 
         but ideally user should run npm run dev. I'll rely on Vite in production but CDN for quick dev if needed.
         Actually, I'll use the Vite directive as standard Laravel 10/11/12. -->
    <!-- Using CDN for now to ensure immediate specific visual results without build steps. -->
    {{-- @vite(['resources/css/app.css', 'resources/js/app.js']) --}}
    <script src="https://cdn.tailwindcss.com"></script>
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
</head>

<body class="bg-gray-900 text-gray-100 font-sans antialiased">
    <div class="min-h-screen flex flex-col">
        <!-- Navigation -->
        @auth
            <nav class="bg-gray-800 border-b border-gray-700">
                <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                    <div class="flex items-center justify-between h-16">
                        <div class="flex items-center">
                            <div class="flex-shrink-0 text-amber-500 font-bold text-xl">
                                Sukha Cigar Bar & Lounge
                            </div>
                            <div class="hidden md:block">
                                <div class="ml-10 flex items-baseline space-x-4">
                                    @if(auth()->user()->isAdmin())
                                        <a href="{{ route('admin.dashboard') }}"
                                            class="text-amber-500 hover:bg-gray-700 px-3 py-2 rounded-md text-sm font-medium">Dashboard</a>

                                        <!-- Catálogo Dropdown -->
                                        <div class="relative group inline-block">
                                            <button
                                                class="text-gray-300 hover:bg-gray-700 hover:text-white px-3 py-2 rounded-md text-sm font-medium">Catálogo</button>
                                            <div class="absolute left-0 pt-2 w-48 hidden group-hover:block z-50">
                                                <div class="bg-gray-800 rounded-md shadow-lg py-1 border border-gray-700">
                                                    <a href="{{ route('products.index') }}"
                                                        class="block px-4 py-2 text-sm text-gray-300 hover:bg-gray-700">Productos</a>
                                                    <a href="{{ route('categories.index') }}"
                                                        class="block px-4 py-2 text-sm text-gray-300 hover:bg-gray-700">Categorías</a>
                                                </div>
                                            </div>
                                        </div>

                                        <a href="{{ route('inventory.index') }}"
                                            class="text-gray-300 hover:bg-gray-700 hover:text-white px-3 py-2 rounded-md text-sm font-medium">Inventario</a>

                                        <div class="relative group inline-block">
                                            <button
                                                class="text-gray-300 hover:bg-gray-700 hover:text-white px-3 py-2 rounded-md text-sm font-medium">Reportes</button>
                                            <div class="absolute left-0 pt-2 w-48 hidden group-hover:block z-50">
                                                <div class="bg-gray-800 rounded-md shadow-lg py-1 border border-gray-700">
                                                    <a href="{{ route('reports.daily_sales') }}"
                                                        class="block px-4 py-2 text-sm text-gray-300 hover:bg-gray-700">Ventas
                                                        Diarias</a>
                                                    <a href="{{ route('reports.product_sales') }}"
                                                        class="block px-4 py-2 text-sm text-gray-300 hover:bg-gray-700">Ventas
                                                        por
                                                        Producto</a>
                                                    <a href="{{ route('reports.inventory') }}"
                                                        class="block px-4 py-2 text-sm text-gray-300 hover:bg-gray-700">Valor
                                                        Inventario</a>
                                                    <a href="{{ route('reports.inventory.print') }}" target="_blank"
                                                        class="block px-4 py-2 text-sm text-amber-500 hover:bg-gray-700 font-bold">Inventario
                                                        Físico</a>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="relative group inline-block">
                                            <button
                                                class="text-gray-300 hover:bg-gray-700 hover:text-white px-3 py-2 rounded-md text-sm font-medium">Configuración</button>
                                            <div class="absolute left-0 pt-2 w-48 hidden group-hover:block z-50">
                                                <div class="bg-gray-800 rounded-md shadow-lg py-1 border border-gray-700">
                                                    <a href="{{ route('employees.index') }}"
                                                        class="block px-4 py-2 text-sm text-gray-300 hover:bg-gray-700">Personal
                                                        (Usuarios)</a>
                                                    <div class="border-t border-gray-700 my-1"></div>
                                                    <a href="{{ route('printers.index') }}"
                                                        class="block px-4 py-2 text-sm text-gray-300 hover:bg-gray-700">Impresoras</a>
                                                    <a href="{{ route('designer.index') }}"
                                                        class="block px-4 py-2 text-sm text-gray-300 hover:bg-gray-700">Diseñador
                                                        Recibos</a>
                                                    <a href="{{ route('admin.menu.designer') }}"
                                                        class="block px-4 py-2 text-sm text-gray-300 hover:bg-gray-700">Menú
                                                        Digital (QR)</a>
                                                    <div class="border-t border-gray-700 my-1"></div>
                                                    <a href="{{ route('admin.mesas.index') }}"
                                                        class="block px-4 py-2 text-sm text-gray-300 hover:bg-gray-700">Gestión
                                                        de Mesas y Zonas</a>
                                                    <div class="border-t border-gray-700 my-1"></div>
                                                    <a href="{{ route('admin.business.index') }}"
                                                        class="block px-4 py-2 text-sm text-amber-500 hover:bg-gray-700 font-bold">Datos
                                                        del Negocio</a>
                                                </div>
                                            </div>
                                        </div>
                                    @endif

                                    <div class="border-l border-gray-700 h-6 mx-2 self-center"></div>

                                    <a href="{{ route('pos.index') }}"
                                        class="text-amber-500 font-bold hover:bg-gray-700 px-3 py-2 rounded-md text-sm font-medium">Ventas
                                        (POS)</a>
                                    <a href="{{ route('caja.operations') }}"
                                        class="text-gray-300 hover:bg-gray-700 hover:text-white px-3 py-2 rounded-md text-sm font-medium">Caja</a>
                                </div>
                            </div>
                        </div>
                        <div class="hidden md:block">
                            <div class="ml-4 flex items-center md:ml-6">
                                <span class="text-gray-300 text-sm mr-4">{{ auth()->user()->name }}
                                    ({{ auth()->user()->role->name }})</span>
                                <form method="POST" action="{{ route('logout') }}">
                                    @csrf
                                    <button type="submit"
                                        class="bg-red-600 hover:bg-red-700 text-white px-3 py-2 rounded-md text-sm font-medium">
                                        Salir
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </nav>
        @endauth

        <!-- Content -->
        <main class="flex-grow max-w-7xl mx-auto w-full px-4 sm:px-6 lg:px-8 py-6">
            @if(session('success'))
                <div class="bg-green-600 text-white p-4 rounded-lg mb-6 shadow-lg flex items-center">
                    <i class="bi bi-check-circle-fill mr-2"></i>
                    {{ session('success') }}
                </div>
            @endif

            @if(session('error') || $errors->any())
                <div class="bg-red-600 text-white p-4 rounded-lg mb-6 shadow-lg">
                    <div class="flex items-center font-bold mb-1">
                        <i class="bi bi-exclamation-triangle-fill mr-2"></i>
                        Atención
                    </div>
                    <ul class="list-disc list-inside text-sm opacity-90">
                        @if(session('error'))
                            <li>{{ session('error') }}</li>
                        @endif
                        @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            @yield('content')
        </main>

        <!-- Footer -->
        <footer class="bg-gray-800 text-center py-4 text-gray-500 text-sm">
            &copy; {{ date('Y') }} Sukha Cigar Bar & Lounge
        </footer>
    </div>
    @if(session('print_order'))
        <script>
            window.addEventListener('load', function () {
                const printUrl = "{{ route('pos.order.print-browser', ['orden' => session('print_order'), 'tipo' => session('print_type')]) }}";
                const printWindow = window.open(printUrl, '_blank');

                if (!printWindow) {
                    alert('El navegador bloqueó la ventana de impresión automática. Por favor, permite ventanas emergentes para este sitio.');
                }
            });
        </script>
    @endif
</body>

</html>