<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Inventario Físico - {{ now()->format('d/m/Y') }}</title>
    <style>
        @page {
            margin: 0;
            size: 80mm auto;
        }

        body {
            font-family: 'Courier New', Courier, monospace;
            font-size: 12px;
            margin: 0;
            padding: 5mm;
            width: 70mm;
            background-color: white;
            color: black;
        }

        .header {
            text-align: center;
            margin-bottom: 5mm;
        }

        .header h1 {
            font-size: 16px;
            margin: 0;
            text-transform: uppercase;
        }

        .divider {
            border-bottom: 1px dashed black;
            margin: 3mm 0;
        }

        .info-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 1mm;
        }

        .category-header {
            background-color: #eee;
            padding: 1mm;
            font-weight: bold;
            text-transform: uppercase;
            margin-top: 3mm;
            border-bottom: 1px solid black;
        }

        .items-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 3mm;
        }

        .items-table th {
            text-align: left;
            border-bottom: 1px solid black;
            padding-bottom: 1mm;
            font-size: 10px;
        }

        .items-table td {
            padding: 1.5mm 0;
            vertical-align: top;
            border-bottom: 0.1px solid #eee;
        }

        .text-right {
            text-align: right;
        }

        .bold {
            font-weight: bold;
        }

        .footer {
            text-align: center;
            margin-top: 10mm;
            font-size: 10px;
        }

        .signature-line {
            margin-top: 15mm;
            border-top: 1px solid black;
            text-align: center;
            padding-top: 2mm;
        }

        @media print {
            .no-print {
                display: none;
            }

            body {
                padding: 0;
            }
        }

        .print-btn {
            position: fixed;
            top: 10px;
            right: 10px;
            padding: 10px 20px;
            background: #10b981;
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-family: sans-serif;
            font-weight: bold;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.2);
        }
    </style>
</head>

<body>
    <button class="no-print print-btn" onclick="window.print()">IMPRIMIR REPORTE</button>

    <div class="header">
        <h1>{{ $config->business_name }}</h1>
        <p>REPORTE DE INVENTARIO</p>
    </div>

    <div class="divider"></div>

    <div class="info-row">
        <span>Fecha:</span>
        <span>{{ now()->format('d/m/Y') }}</span>
    </div>
    <div class="info-row">
        <span>Hora:</span>
        <span>{{ now()->format('h:i A') }}</span>
    </div>
    <div class="info-row">
        <span>Generado por:</span>
        <span>{{ Auth::user()->name }}</span>
    </div>

    <div class="divider"></div>

    @foreach($categories as $category)
        @if($category->products->count() > 0)
            <div class="category-header">{{ $category->name }}</div>
            <table class="items-table">
                <thead>
                    <tr>
                        <th width="70%">Producto</th>
                        <th width="30%" class="text-right">Sistema</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($category->products as $product)
                        <tr>
                            <td>{{ $product->name }}</td>
                            <td class="text-right bold">{{ number_format($product->stock, 2) }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        @endif
    @endforeach

    <div class="divider"></div>

    <div class="signature-line">
        Firma Responsable
    </div>

    <div class="footer">
        <p>Sukha Cigar Bar - Inventario de Sistema</p>
        <p>{{ now()->format('d/m/Y H:i:s') }}</p>
    </div>

    <script>
        window.onload = function () {
            // Uncomment to auto-print
            // window.print();
        }
    </script>
</body>

</html>