@extends('layouts.app')

@section('content')
    <div class="max-w-7xl mx-auto py-6 sm:px-6 lg:px-8">
        <div class="flex justify-between items-center mb-6">
            <h1 class="text-3xl font-bold text-gray-100">Reporte de Ventas Diarias</h1>
            <form action="{{ route('reports.daily_sales') }}" method="GET" class="flex gap-2">
                <input type="date" name="date" value="{{ $date }}"
                    class="bg-gray-700 border border-gray-600 rounded p-2 text-white">
                <button type="submit"
                    class="bg-blue-600 hover:bg-blue-500 text-white font-bold py-2 px-4 rounded">Filtrar</button>
            </form>
        </div>

        <!-- Summary Cards -->
        <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-8">
            <div class="bg-gray-800 rounded-lg shadow p-6 border-l-4 border-green-500">
                <h3 class="text-gray-400 text-sm font-medium">Ventas Reales</h3>
                <p class="text-3xl font-bold text-green-400 mt-2">${{ number_format($totalSales, 2) }}</p>
            </div>
            <div class="bg-gray-800 rounded-lg shadow p-6 border-l-4 border-amber-500">
                <h3 class="text-gray-400 text-sm font-medium">Consumo Interno</h3>
                <p class="text-3xl font-bold text-amber-500 mt-2">${{ number_format($totalInternal, 2) }}</p>
            </div>
            @foreach($paymentMethods as $method => $amount)
                <div class="bg-gray-800 rounded-lg shadow p-6">
                    <h3 class="text-gray-400 text-sm font-medium">Por {{ ucfirst($method) }}</h3>
                    <p class="text-2xl font-bold text-blue-400 mt-2">${{ number_format($amount, 2) }}</p>
                </div>
            @endforeach
        </div>

        <!-- Detailed List (Actual Sales) -->
        <div class="mb-4">
            <h2 class="text-xl font-bold text-gray-300 mb-2">Detalle de Ventas Reales</h2>
            <div class="bg-gray-800 shadow rounded-lg overflow-hidden">
                <table class="min-w-full divide-y divide-gray-700">
                    <thead class="bg-gray-700">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">ID
                                Venta</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Hora
                            </th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">
                                Cajero</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">
                                Método</th>
                            <th class="px-6 py-3 text-right text-xs font-medium text-gray-300 uppercase tracking-wider">
                                Total</th>
                            <th class="px-6 py-3 text-right text-xs font-medium text-gray-300 uppercase tracking-wider">
                                Acciones</th>
                        </tr>
                    </thead>
                    <tbody class="bg-gray-800 divide-y divide-gray-700 text-gray-200">
                        @foreach ($sales as $sale)
                            <tr>
                                <td class="px-6 py-4 whitespace-nowrap">#{{ $sale->id }}</td>
                                <td class="px-6 py-4 whitespace-nowrap">{{ $sale->created_at->format('h:i:s A') }}</td>
                                <td class="px-6 py-4 whitespace-nowrap">{{ $sale->user->name }}</td>
                                <td class="px-6 py-4 whitespace-nowrap">{{ ucfirst($sale->payment_method) }}</td>
                                <td class="px-6 py-4 whitespace-nowrap text-right font-bold text-green-400">
                                    ${{ number_format($sale->total, 2) }}</td>
                                <td class="px-6 py-4 whitespace-nowrap text-right text-sm">
                                    <a href="{{ route('pos.order.print-browser', ['orden' => $sale->orden_id, 'tipo' => 'factura']) }}"
                                        target="_blank" class="text-amber-500 hover:text-amber-400 font-bold">
                                        Re-imprimir
                                    </a>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>

        <!-- Detailed List (Internal Consumption) -->
        <div class="mt-8">
            <h2 class="text-xl font-bold text-amber-500 mb-2">Detalle de Consumo Interno</h2>
            <div class="bg-gray-800 shadow rounded-lg overflow-hidden border border-amber-900/30">
                <table class="min-w-full divide-y divide-gray-700">
                    <thead class="bg-amber-900/20">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-400 uppercase tracking-wider">ID
                            </th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-400 uppercase tracking-wider">Hora
                            </th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-400 uppercase tracking-wider">
                                Autorizó</th>
                            <th class="px-6 py-3 text-right text-xs font-medium text-gray-400 uppercase tracking-wider">
                                Valor</th>
                            <th class="px-6 py-3 text-right text-xs font-medium text-gray-400 uppercase tracking-wider">
                                Acciones</th>
                        </tr>
                    </thead>
                    <tbody class="bg-gray-800 divide-y divide-gray-700 text-gray-300">
                        @forelse ($internalSales as $sale)
                            <tr>
                                <td class="px-6 py-4 whitespace-nowrap">#{{ $sale->id }}</td>
                                <td class="px-6 py-4 whitespace-nowrap">{{ $sale->created_at->format('h:i:s A') }}</td>
                                <td class="px-6 py-4 whitespace-nowrap">{{ $sale->user->name }}</td>
                                <td class="px-6 py-4 whitespace-nowrap text-right font-bold text-amber-400">
                                    ${{ number_format($sale->total, 2) }}</td>
                                <td class="px-6 py-4 whitespace-nowrap text-right text-sm">
                                    <a href="{{ route('pos.order.print-browser', ['orden' => $sale->orden_id, 'tipo' => 'factura']) }}"
                                        target="_blank" class="text-gray-500 hover:text-gray-300">
                                        Ver Ticket
                                    </a>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="5" class="px-6 py-4 text-center italic text-gray-500">No hay consumos internos
                                    registrados hoy</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection