@extends('layouts.app')

@section('content')
    <div class="max-w-7xl mx-auto py-6 sm:px-6 lg:px-8">
        <div class="flex justify-between items-center mb-6">
            <h1 class="text-3xl font-bold text-white">Configuración de Impresoras</h1>
            <div class="flex space-x-3">
                <a href="{{ route('printers.discover') }}"
                    class="bg-gray-700 hover:bg-gray-600 text-white font-bold py-2 px-4 rounded transition duration-150 flex items-center">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-2 text-amber-500" fill="none"
                        viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z" />
                    </svg>
                    Detectar Automáticamente
                </a>
                <a href="{{ route('printers.create') }}"
                    class="bg-amber-500 hover:bg-amber-400 text-gray-900 font-bold py-2 px-4 rounded transition duration-150">
                    Nueva Impresora
                </a>
            </div>
        </div>

        @if(session('success'))
            <div class="bg-green-600 text-white p-4 rounded-lg mb-6">
                {{ session('success') }}
            </div>
        @endif

        <div class="bg-gray-800 rounded-lg shadow overflow-hidden border border-gray-700">
            <table class="min-w-full divide-y divide-gray-700">
                <thead class="bg-gray-700">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Nombre
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Tipo / IP
                        </th>
                        <th class="px-6 py-3 text-center text-xs font-medium text-gray-300 uppercase tracking-wider">
                            Predeterminada</th>
                        <th class="px-6 py-3 text-center text-xs font-medium text-gray-300 uppercase tracking-wider">Estado
                        </th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-300 uppercase tracking-wider">Acciones
                        </th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-700">
                    @foreach($printers as $printer)
                        <tr class="hover:bg-gray-750 transition-colors">
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="text-white font-medium">{{ $printer->nombre }}</div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="text-gray-300 capitalize">{{ $printer->tipo }}</div>
                                @if($printer->tipo === 'network')
                                    <div class="text-xs text-gray-500">{{ $printer->ip }}:{{ $printer->puerto }}</div>
                                @endif
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-center">
                                @if($printer->es_predeterminada)
                                    <span class="px-2 py-1 text-xs font-bold bg-green-900 text-green-300 rounded-full">SÍ</span>
                                @else
                                    <form action="{{ route('printers.default', $printer) }}" method="POST">
                                        @csrf
                                        <button type="submit" class="text-xs text-gray-400 hover:text-white underline">Hacer
                                            predeterminada</button>
                                    </form>
                                @endif
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-center">
                                <span
                                    class="px-2 py-1 text-xs font-bold {{ $printer->activa ? 'bg-blue-900 text-blue-300' : 'bg-gray-700 text-gray-400' }} rounded-full">
                                    {{ $printer->activa ? 'ACTIVA' : 'INACTIVA' }}
                                </span>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                                <a href="{{ route('printers.edit', $printer) }}"
                                    class="text-amber-500 hover:text-amber-400 mr-3">Editar</a>
                                <form action="{{ route('printers.destroy', $printer) }}" method="POST" class="inline-block"
                                    onsubmit="return confirm('¿Eliminar esta impresora?')">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="text-red-500 hover:text-red-400">Eliminar</button>
                                </form>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection