@extends('layouts.app')

@section('content')
    <div class="container mx-auto" x-data="{ 
            showZonaModal: false,
            showMesaModal: false,
            showEditTableModal: false,
            zonaId: null,
            zonaNombre: '',
            tableData: { id: null, name: '', capacity: 4, zona_id: null, is_internal: false },

            openNewMesaModal(id = null, nombre = 'Sin Zona') {
                this.zonaId = id;
                this.zonaNombre = nombre;
                this.showMesaModal = true;
            }
        }">
        <div class="flex flex-col md:flex-row justify-between items-start md:items-center gap-4 mb-8">
            <div>
                <h1 class="text-3xl font-bold text-white font-serif">Gestión de Espacios</h1>
                <p class="text-gray-400 text-sm">Organiza tus zonas y mesas para el POS</p>
            </div>
            <div class="flex gap-3">
                <button @click="showZonaModal = true"
                    class="bg-gray-800 hover:bg-gray-700 text-amber-500 border border-amber-500/30 px-5 py-2.5 rounded-xl font-bold transition flex items-center gap-2">
                    <i class="bi bi-layers"></i> Nueva Zona
                </button>
                <button @click="openNewMesaModal()"
                    class="bg-amber-600 hover:bg-amber-500 text-white px-5 py-2.5 rounded-xl font-bold transition shadow-lg shadow-amber-900/20 flex items-center gap-2">
                    <i class="bi bi-plus-circle"></i> Nueva Mesa
                </button>
            </div>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            {{-- List of Zones --}}
            @foreach ($zonas as $zona)
                <div
                    class="bg-gray-800/50 backdrop-blur-sm rounded-2xl shadow-xl p-6 border border-gray-700/50 flex flex-col group hover:border-amber-500/30 transition-all duration-300">
                    <div class="flex justify-between items-start mb-6">
                        <div>
                            <div class="flex items-center gap-2 mb-1">
                                <span class="bg-amber-500/10 text-amber-500 p-1.5 rounded-lg">
                                    <i class="bi bi-geo-alt-fill text-sm"></i>
                                </span>
                                <h2 class="text-xl font-bold text-gray-100">{{ $zona->nombre }}</h2>
                            </div>
                            <p class="text-gray-500 text-xs font-medium uppercase tracking-wider">{{ $zona->mesas->count() }}
                                mesas en esta área</p>
                        </div>
                        <form action="{{ route('admin.zonas.destroy', $zona) }}" method="POST"
                            onsubmit="return confirm('¿Eliminar esta zona? Las mesas quedarán sin zona asignada.')">
                            @csrf @method('DELETE')
                            <button type="submit" class="text-gray-600 hover:text-red-500 transition-colors p-2">
                                <i class="bi bi-trash"></i>
                            </button>
                        </form>
                    </div>

                    <div class="space-y-2 mb-6 flex-grow custom-scrollbar overflow-y-auto max-h-64 pr-2">
                        @forelse ($zona->mesas as $mesa)
                            <div
                                class="flex justify-between items-center bg-gray-900/80 p-3 rounded-xl border border-gray-700/50 group/item hover:border-gray-500 transition-all">
                                <div>
                                    <div class="flex items-center gap-2">
                                        <p class="text-sm font-bold text-gray-200">{{ $mesa->name }}</p>
                                        @if($mesa->is_internal)
                                            <span class="bg-purple-500/10 text-purple-400 text-[10px] px-1.5 py-0.5 rounded-md border border-purple-500/20">Uso Interno</span>
                                        @endif
                                    </div>
                                    <p class="text-[10px] text-gray-500">Capacidad: {{ $mesa->capacity }} pers.</p>
                                </div>
                                <div class="flex items-center gap-1 opacity-0 group-hover/item:opacity-100 transition-opacity">
                                    <button
                                        @click="tableData = { id: {{ $mesa->id }}, name: '{{ $mesa->name }}', capacity: {{ $mesa->capacity }}, zona_id: {{ $mesa->zona_id ?? 'null' }}, is_internal: {{ $mesa->is_internal ? 'true' : 'false' }} }; showEditTableModal = true"
                                        class="p-2 text-blue-400 hover:bg-blue-400/10 rounded-lg transition">
                                        <i class="bi bi-pencil-square"></i>
                                    </button>
                                    <form action="{{ route('admin.mesas.destroy', $mesa) }}" method="POST"
                                        onsubmit="return confirm('¿Eliminar esta mesa?')">
                                        @csrf @method('DELETE')
                                        <button type="submit" class="p-2 text-red-500 hover:bg-red-500/10 rounded-lg transition">
                                            <i class="bi bi-x-lg"></i>
                                        </button>
                                    </form>
                                </div>
                            </div>
                        @empty
                            <div class="py-10 text-center border-2 border-dashed border-gray-700 rounded-xl">
                                <p class="text-gray-600 text-xs text-center px-4">Esta zona está vacía</p>
                            </div>
                        @endforelse
                    </div>

                    <button @click="openNewMesaModal({{ $zona->id }}, '{{ $zona->nombre }}')"
                        class="w-full py-2.5 border-2 border-dashed border-gray-700 rounded-xl text-gray-500 hover:border-amber-500/50 hover:text-amber-500 transition-all font-bold text-sm">
                        + Agregar a {{ $zona->nombre }}
                    </button>
                </div>
            @endforeach

            {{-- Unassigned Tables --}}
            @if($mesasSinZona->count() > 0)
                <div
                    class="bg-red-950/10 backdrop-blur-sm rounded-2xl shadow-xl p-6 border border-red-900/30 flex flex-col ring-1 ring-red-900/20 shadow-red-900/5">
                    <div class="flex items-center gap-2 mb-6">
                        <span class="bg-red-500/20 text-red-500 p-1.5 rounded-lg">
                            <i class="bi bi-exclamation-triangle-fill text-sm"></i>
                        </span>
                        <div>
                            <h2 class="text-xl font-bold text-red-400">Sin Zona</h2>
                            <p class="text-red-900/60 text-[10px] font-bold uppercase tracking-widest">Invisibles en el POS</p>
                        </div>
                    </div>

                    <div class="space-y-2 flex-grow">
                        @foreach ($mesasSinZona as $mesa)
                            <div
                                class="flex justify-between items-center bg-gray-900/80 p-3 rounded-xl border border-red-900/20 group/un">
                                <div>
                                    <p class="text-sm font-bold text-gray-200">{{ $mesa->name }}</p>
                                    <p class="text-[10px] text-gray-500">Haz clic en editar para asignar</p>
                                </div>
                                <div class="flex items-center gap-1">
                                    <button
                                        @click="tableData = { id: {{ $mesa->id }}, name: '{{ $mesa->name }}', capacity: {{ $mesa->capacity }}, zona_id: null }; showEditTableModal = true"
                                        class="p-2 text-amber-500 hover:bg-amber-500/10 rounded-lg transition">
                                        <i class="bi bi-pencil-square"></i>
                                    </button>
                                    <form action="{{ route('admin.mesas.destroy', $mesa) }}" method="POST">
                                        @csrf @method('DELETE')
                                        <button type="submit" class="p-2 text-red-500 hover:bg-red-500/10 rounded-lg transition">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </form>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            @endif
        </div>

        {{-- Modals --}}
        <div>
            {{-- Modal New Zona --}}
            <div x-show="showZonaModal" x-transition.opacity
                class="fixed inset-0 z-50 flex items-center justify-center p-4 bg-black/80 backdrop-blur-md" x-cloak>
                <div @click.away="showZonaModal = false"
                    class="bg-gray-800 rounded-3xl w-full max-w-md p-8 border border-gray-700 shadow-2xl">
                    <div class="flex items-center gap-3 mb-8">
                        <div class="bg-amber-600/20 p-3 rounded-2xl">
                            <i class="bi bi-layers text-2xl text-amber-500"></i>
                        </div>
                        <h3 class="text-2xl font-bold text-white font-serif">Nueva Zona</h3>
                    </div>

                    <form action="{{ route('admin.zonas.store') }}" method="POST">
                        @csrf
                        <div class="mb-5">
                            <label class="block text-gray-400 text-xs font-bold uppercase tracking-widest mb-2">Nombre del
                                Área</label>
                            <input type="text" name="nombre"
                                class="w-full bg-gray-900 border border-gray-700 rounded-xl p-4 text-white focus:border-amber-500 outline-none transition"
                                placeholder="Ej: Terraza Exterior, Barra VIP..." required autofocus>
                        </div>
                        <div class="mb-8">
                            <label class="block text-gray-400 text-xs font-bold uppercase tracking-widest mb-2">Orden de
                                Visualización</label>
                            <input type="number" name="orden" value="0"
                                class="w-full bg-gray-900 border border-gray-700 rounded-xl p-4 text-white focus:border-amber-500 outline-none transition">
                            <p class="text-[10px] text-gray-500 mt-2">Determina el orden de las pestañas en el POS.</p>
                        </div>
                        <div class="flex gap-4">
                            <button type="button" @click="showZonaModal = false"
                                class="flex-1 px-4 py-4 bg-gray-700 text-white rounded-2xl font-bold hover:bg-gray-600 transition">Cancelar</button>
                            <button type="submit"
                                class="flex-1 px-4 py-4 bg-amber-600 text-white rounded-2xl font-bold hover:bg-amber-500 shadow-xl shadow-amber-900/30 transition">Crear
                                Área</button>
                        </div>
                    </form>
                </div>
            </div>

            {{-- Modal New Mesa --}}
            <div x-show="showMesaModal" x-transition.opacity
                class="fixed inset-0 z-50 flex items-center justify-center p-4 bg-black/80 backdrop-blur-md" x-cloak>
                <div @click.away="showMesaModal = false"
                    class="bg-gray-800 rounded-3xl w-full max-w-md p-8 border border-gray-700 shadow-2xl">
                    <div class="flex items-center justify-between mb-8">
                        <div class="flex items-center gap-3">
                            <div class="bg-amber-600/20 p-3 rounded-2xl">
                                <i class="bi bi-plus-circle text-2xl text-amber-500"></i>
                            </div>
                            <h3 class="text-2xl font-bold text-white font-serif">Nueva Mesa</h3>
                        </div>
                        <div class="text-right">
                            <p class="text-[10px] text-gray-500 uppercase tracking-widest">Ubicación</p>
                            <p class="text-amber-500 font-bold" x-text="zonaNombre"></p>
                        </div>
                    </div>

                    <form action="{{ route('admin.mesas.store') }}" method="POST">
                        @csrf
                        <input type="hidden" name="zona_id" :value="zonaId">
                        <div class="mb-5">
                            <label
                                class="block text-gray-400 text-xs font-bold uppercase tracking-widest mb-2">Identificador</label>
                            <input type="text" name="name"
                                class="w-full bg-gray-900 border border-gray-700 rounded-xl p-4 text-white focus:border-amber-500 outline-none"
                                placeholder="Ej: Mesa 12, Barra B5..." required autofocus>
                        </div>
                        <div class="mb-8">
                            <label
                                class="block text-gray-400 text-xs font-bold uppercase tracking-widest mb-2">Capacidad</label>
                            <div class="relative">
                                <input type="number" name="capacity" value="4" min="1"
                                    class="w-full bg-gray-900 border border-gray-700 rounded-xl p-4 text-white focus:border-amber-500 outline-none">
                                <span
                                    class="absolute right-4 top-1/2 -translate-y-1/2 text-gray-500 text-sm">Personas</span>
                            </div>
                        </div>
                        <div class="mb-8">
                            <label class="flex items-center cursor-pointer group">
                                <div class="relative">
                                    <input type="checkbox" name="is_internal" value="1" class="sr-only peer">
                                    <div class="w-10 h-6 bg-gray-700 peer-focus:outline-none rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-purple-600"></div>
                                </div>
                                <span class="ml-3 text-sm font-bold text-gray-300 group-hover:text-purple-400 transition-colors">Mesa para Uso Interno (Dueño)</span>
                            </label>
                            <p class="text-[10px] text-gray-500 mt-2">Las ventas en esta mesa no afectarán el balance de efectivo de la caja.</p>
                        </div>
                        <div class="flex gap-4">
                            <button type="button" @click="showMesaModal = false"
                                class="flex-1 px-4 py-4 bg-gray-700 text-white rounded-2xl font-bold hover:bg-gray-600 transition">Cancelar</button>
                            <button type="submit"
                                class="flex-1 px-4 py-4 bg-amber-600 text-white rounded-2xl font-bold hover:bg-amber-500 shadow-xl shadow-amber-900/30 transition">Guardar
                                Mesa</button>
                        </div>
                    </form>
                </div>
            </div>

            {{-- Modal EDIT Mesa --}}
            <div x-show="showEditTableModal" x-transition.opacity
                class="fixed inset-0 z-50 flex items-center justify-center p-4 bg-black/80 backdrop-blur-md" x-cloak>
                <div @click.away="showEditTableModal = false"
                    class="bg-gray-800 rounded-3xl w-full max-w-md p-8 border border-gray-700 shadow-2xl">
                    <div class="flex items-center gap-3 mb-8">
                        <div class="bg-blue-600/20 p-3 rounded-2xl">
                            <i class="bi bi-pencil-square text-2xl text-blue-500"></i>
                        </div>
                        <h3 class="text-2xl font-bold text-white font-serif">Configurar Mesa</h3>
                    </div>

                    <form :action="'{{ url('/admin/mesas') }}/' + tableData.id" method="POST">
                        @csrf @method('PUT')
                        <div class="mb-5">
                            <label class="block text-gray-400 text-xs font-bold uppercase tracking-widest mb-2">Nombre /
                                Ref</label>
                            <input type="text" name="name" x-model="tableData.name"
                                class="w-full bg-gray-900 border border-gray-700 rounded-xl p-4 text-white focus:border-blue-500 outline-none transition"
                                required>
                        </div>
                        <div class="mb-5">
                            <label
                                class="block text-gray-400 text-xs font-bold uppercase tracking-widest mb-2">Capacidad</label>
                            <input type="number" name="capacity" x-model="tableData.capacity" min="1"
                                class="w-full bg-gray-900 border border-gray-700 rounded-xl p-4 text-white focus:border-blue-500 outline-none transition">
                        </div>
                        <div class="mb-8">
                            <label class="block text-gray-400 text-xs font-bold uppercase tracking-widest mb-2">Asignar Zona
                                (Ubicación)</label>
                            <select name="zona_id" x-model="tableData.zona_id"
                                class="w-full bg-gray-900 border border-gray-700 rounded-xl p-4 text-white focus:border-blue-500 outline-none transition appearance-none">
                                <option value="">Sin Zona (Oculto)</option>
                                @foreach($zonas as $z)
                                    <option value="{{ $z->id }}">{{ $z->nombre }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="mb-8">
                            <label class="flex items-center cursor-pointer group">
                                <div class="relative">
                                    <input type="checkbox" name="is_internal" value="1" x-model="tableData.is_internal" class="sr-only peer">
                                    <div class="w-10 h-6 bg-gray-700 peer-focus:outline-none rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-purple-600"></div>
                                </div>
                                <span class="ml-3 text-sm font-bold text-gray-300 group-hover:text-purple-400 transition-colors">Mesa para Uso Interno (Dueño)</span>
                            </label>
                            <p class="text-[10px] text-gray-500 mt-2">Las ventas en esta mesa no afectarán el balance de efectivo de la caja.</p>
                        </div>
                        <div class="flex gap-4">
                            <button type="button" @click="showEditTableModal = false"
                                class="flex-1 px-4 py-4 bg-gray-700 text-white rounded-2xl font-bold hover:bg-gray-600 transition">Cancelar</button>
                            <button type="submit"
                                class="flex-1 px-4 py-4 bg-blue-600 text-white rounded-2xl font-bold hover:bg-blue-500 shadow-xl shadow-blue-900/30 transition">Actualizar</button>
                        </div>
                    </form>
                </div>
            </div>

        </div>
    </div>

    <style>
        .custom-scrollbar::-webkit-scrollbar {
            width: 5px;
        }

        .custom-scrollbar::-webkit-scrollbar-track {
            background: transparent;
        }

        .custom-scrollbar::-webkit-scrollbar-thumb {
            background: #374151;
            border-radius: 10px;
        }

        .custom-scrollbar::-webkit-scrollbar-thumb:hover {
            background: #4b5563;
        }
    </style>
@endsection