@extends('layouts.app')

@section('content')
    <div class="max-w-4xl mx-auto py-6 sm:px-6 lg:px-8">
        <h1 class="text-3xl font-bold text-gray-100 mb-6">Nuevo Empleado</h1>

        <div class="bg-gray-800 shadow rounded-lg p-6">
            <form action="{{ route('employees.store') }}" method="POST">
                @csrf

                <div class="mb-4">
                    <label for="name" class="block text-gray-300 text-sm font-bold mb-2">Nombre Completo</label>
                    <input type="text" name="name" id="name"
                        class="w-full bg-gray-700 border border-gray-600 rounded p-2 text-white placeholder-gray-400"
                        required>
                </div>

                <div class="mb-4">
                    <label for="email" class="block text-gray-300 text-sm font-bold mb-2">Email</label>
                    <input type="email" name="email" id="email"
                        class="w-full bg-gray-700 border border-gray-600 rounded p-2 text-white placeholder-gray-400"
                        required>
                </div>

                <div class="mb-4">
                    <label for="role_id" class="block text-gray-300 text-sm font-bold mb-2">Rol</label>
                    <select name="role_id" id="role_id"
                        class="w-full bg-gray-700 border border-gray-600 rounded p-2 text-white">
                        @foreach($roles as $role)
                            <option value="{{ $role->id }}">{{ $role->name }}</option>
                        @endforeach
                    </select>
                </div>

                <div class="mb-4">
                    <label for="password" class="block text-gray-300 text-sm font-bold mb-2">Contraseña</label>
                    <input type="password" name="password" id="password"
                        class="w-full bg-gray-700 border border-gray-600 rounded p-2 text-white placeholder-gray-400"
                        required>
                </div>

                <div class="mb-6">
                    <label for="password_confirmation" class="block text-gray-300 text-sm font-bold mb-2">Confirmar
                        Contraseña</label>
                    <input type="password" name="password_confirmation" id="password_confirmation"
                        class="w-full bg-gray-700 border border-gray-600 rounded p-2 text-white placeholder-gray-400"
                        required>
                </div>

                <div class="flex justify-end gap-4">
                    <a href="{{ route('employees.index') }}"
                        class="bg-gray-600 hover:bg-gray-500 text-white font-bold py-2 px-4 rounded">Cancelar</a>
                    <button type="submit"
                        class="bg-green-600 hover:bg-green-500 text-white font-bold py-2 px-4 rounded">Guardar
                        Empleado</button>
                </div>
            </form>
        </div>
    </div>
@endsection