@extends('layouts.app')

@section('content')
    <div class="max-w-3xl mx-auto py-6 sm:px-6 lg:px-8">
        <div class="bg-gray-800 rounded-lg shadow-xl p-8 border border-gray-700">
            <h1 class="text-2xl font-bold text-white mb-6">Editar Categoría</h1>

            <form action="{{ route('categories.update', $category) }}" method="POST">
                @csrf
                @method('PUT')
                <div class="mb-4">
                    <label for="name" class="block text-gray-300 font-bold mb-2">Nombre</label>
                    <input type="text" name="name" id="name"
                        class="w-full bg-gray-700 border border-gray-600 rounded-md py-2 px-3 text-white focus:outline-none focus:ring-2 focus:ring-amber-500"
                        value="{{ old('name', $category->name) }}" required>
                    @error('name') <p class="text-red-500 text-sm mt-1">{{ $message }}</p> @enderror
                </div>

                <div class="mb-4">
                    <label for="icon" class="block text-gray-300 font-bold mb-2">Icono (Ej: drink, food, cigar)</label>
                    <input type="text" name="icon" id="icon"
                        class="w-full bg-gray-700 border border-gray-600 rounded-md py-2 px-3 text-white focus:outline-none focus:ring-2 focus:ring-amber-500"
                        value="{{ old('icon', $category->icon) }}" placeholder="drink">
                    <p class="text-xs text-gray-500 mt-1">Palabra clave para el icono visual en el POS.</p>
                    @error('icon') <p class="text-red-500 text-sm mt-1">{{ $message }}</p> @enderror
                </div>

                <div class="mb-6">
                    <label for="description" class="block text-gray-300 font-bold mb-2">Descripción (Opcional)</label>
                    <textarea name="description" id="description" rows="4"
                        class="w-full bg-gray-700 border border-gray-600 rounded-md py-2 px-3 text-white focus:outline-none focus:ring-2 focus:ring-amber-500">{{ old('description', $category->description) }}</textarea>
                    @error('description') <p class="text-red-500 text-sm mt-1">{{ $message }}</p> @enderror
                </div>

                <div class="flex items-center justify-end space-x-4">
                    <a href="{{ route('categories.index') }}"
                        class="text-gray-400 hover:text-white transition-colors">Cancelar</a>
                    <button type="submit"
                        class="bg-amber-500 hover:bg-amber-400 text-gray-900 font-bold py-2 px-6 rounded shadow transition duration-150">
                        Actualizar Categoría
                    </button>
                </div>
            </form>
        </div>
    </div>
@endsection