<?php

namespace Database\Seeders;

use App\Models\User;
use App\Models\Role;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class UserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $adminRole = Role::where('name', 'Administrador')->first();
        $cajeroRole = Role::where('name', 'Cajero')->first();

        User::create([
            'name' => 'Admin Sukha',
            'email' => 'admin@sukha.com',
            'password' => 'password',
            'role_id' => $adminRole->id,
            'is_active' => true,
        ]);

        User::create([
            'name' => 'Cajero 1',
            'email' => 'cajero@sukha.com',
            'password' => 'password',
            'role_id' => $cajeroRole->id,
            'is_active' => true,
        ]);
    }
}
