<?php

namespace Database\Seeders;

use App\Models\Category;
use Illuminate\Database\Seeder;

class CategorySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $categories = [
            ['name' => 'Cigarros', 'description' => 'Cigarros y puros premium'],
            ['name' => 'Bebidas Espirituosas', 'description' => 'Whisky, Ron, Coñac'],
            ['name' => 'Vinos', 'description' => 'Blancos, Tintos y Espumosos'],
            ['name' => 'Coctelería', 'description' => 'Tragos preparados'],
            ['name' => 'Snacks', 'description' => 'Aperitivos y comida ligera'],
        ];

        foreach ($categories as $category) {
            Category::create($category);
        }
    }
}
