<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('mesas', function (Blueprint $table) {
            $table->index('status');
        });

        Schema::table('ordenes', function (Blueprint $table) {
            $table->index(['estado', 'created_at']);
        });

        Schema::table('sales', function (Blueprint $table) {
            $table->index('created_at');
        });

        Schema::table('apertura_cajas', function (Blueprint $table) {
            $table->index(['estado', 'user_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('mesas', function (Blueprint $table) {
            $table->dropIndex(['status']);
        });

        Schema::table('ordenes', function (Blueprint $table) {
            $table->dropIndex(['estado', 'created_at']);
        });

        Schema::table('sales', function (Blueprint $table) {
            $table->dropIndex(['created_at']);
        });

        Schema::table('apertura_cajas', function (Blueprint $table) {
            $table->dropIndex(['estado', 'user_id']);
        });
    }
};
