<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('sales', function (Blueprint $table) {
            $table->id();
            $table->foreignId('apertura_caja_id')->constrained('apertura_cajas');
            $table->foreignId('orden_id')->nullable()->constrained('ordenes'); // Link to operational order
            $table->foreignId('user_id')->constrained('users');
            $table->decimal('total', 10, 2);
            $table->enum('payment_method', ['cash', 'card', 'transfer', 'other'])->default('cash');
            $table->decimal('amount_paid', 10, 2)->nullable(); // Payed amount
            $table->decimal('change_given', 10, 2)->default(0); // Change returned
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('sales');
    }
};
