<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('arqueos', function (Blueprint $table) {
            $table->id();
            $table->foreignId('apertura_caja_id')->constrained('apertura_cajas')->onDelete('cascade');
            $table->foreignId('user_id')->constrained('users'); // Who performed the arqueo (usually cashier)
            $table->decimal('monto_sistema', 10, 2); // Expected amount
            $table->decimal('monto_fisico', 10, 2); // Real counted amount
            $table->decimal('diferencia', 10, 2); // Calculated difference
            $table->text('observaciones')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('arqueos');
    }
};
