<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Mesa extends Model
{
    use HasFactory;

    protected $fillable = ['name', 'capacity', 'status', 'location', 'is_active', 'zona_id', 'is_internal'];

    protected $casts = [
        'is_active' => 'boolean',
        'is_internal' => 'boolean',
    ];

    public function zona()
    {
        return $this->belongsTo(Zona::class);
    }

    public function activeOrder()
    {
        return $this->hasOne(Orden::class)->whereIn('estado', ['abierta', 'activa'])->latest();
    }
}
