<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Caja extends Model
{
    use HasFactory;

    protected $fillable = ['name', 'is_active'];

    public function aperturas()
    {
        return $this->hasMany(AperturaCaja::class);
    }

    public function currentApertura()
    {
        return $this->hasOne(AperturaCaja::class)->where('estado', 'abierta')->latest();
    }
}
