<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AperturaCaja extends Model
{
    use HasFactory;

    protected $table = 'apertura_cajas';

    protected $fillable = [
        'caja_id',
        'user_id',
        'monto_inicial',
        'monto_final',
        'fecha_apertura',
        'fecha_cierre',
        'fecha_inicio',
        'fecha_fin',
        'estado',
    ];

    protected $casts = [
        'fecha_apertura' => 'datetime',
        'fecha_cierre' => 'datetime',
        'fecha_inicio' => 'datetime',
        'fecha_fin' => 'datetime',
    ];

    public function caja()
    {
        return $this->belongsTo(Caja::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function arqueo()
    {
        return $this->hasOne(Arqueo::class);
    }

    public function sales()
    {
        return $this->hasMany(Sale::class);
    }
}
