<?php

namespace App\Http\Controllers;

use App\Models\BusinessConfig;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class BusinessConfigController extends Controller
{
    public function index()
    {
        $config = BusinessConfig::first() ?: new BusinessConfig();
        return view('admin.settings.business', compact('config'));
    }

    public function save(Request $request)
    {
        $request->validate([
            'business_name' => 'required|string|max:255',
            'rnc' => 'nullable|string|max:20',
            'phone' => 'nullable|string|max:20',
            'address' => 'nullable|string',
            'email' => 'nullable|email|max:255',
            'website' => 'nullable|url|max:255',
            'logo' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048',
        ]);

        // Ensure we only ever have ONE record
        $config = BusinessConfig::first() ?: new BusinessConfig();

        $config->business_name = $request->business_name;
        // ... (rest of field assignments remain same)
        $config->rnc = $request->rnc;
        $config->phone = $request->phone;
        $config->address = $request->address;
        $config->email = $request->email;
        $config->website = $request->website;

        if ($request->hasFile('logo')) {
            if ($config->logo_path) {
                Storage::delete($config->logo_path);
            }
            $path = $request->file('logo')->store('logos', 'public');
            $config->logo_path = $path;
        }

        $config->save();

        // Final fallback to ensure id remains consistent if possible, though first() is usually enough

        return redirect()->back()->with('success', 'Configuración del negocio actualizada correctamente.');
    }
}
