<?php

namespace App\Http\Controllers;

use App\Models\ActivityLog;
use App\Models\AperturaCaja;
use App\Models\Product;
use App\Models\Sale;
use Carbon\Carbon;
use Illuminate\Http\Request;

class AdminController extends Controller
{
    public function index()
    {
        $today = Carbon::today();

        $ventasDia = Sale::where('created_at', '>=', $today)->sum('total');

        $cajaAbierta = AperturaCaja::where('estado', 'abierta')->first();
        $cajaStatus = $cajaAbierta ? 'Abierta' : 'Cerrada';

        $stockAlerts = Product::whereRaw('stock <= min_stock')->count();

        $actividadReciente = ActivityLog::with('user')->latest()->take(5)->get();

        return view('admin.dashboard', compact(
            'ventasDia',
            'cajaStatus',
            'stockAlerts',
            'actividadReciente'
        ));
    }
}
